﻿IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HealthProviderIndividualHpiiGet]') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [hips].[HealthProviderIndividualHpiiGet]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================

-- Create date:   07/10/2015
-- Description:   Gets the HPII for Health Provider Individual
-- =============================================

CREATE PROCEDURE [hips].[HealthProviderIndividualHpiiGet]
(
	@HealthProviderOrganisationNetworkId INT,
	@HealthProviderIndividualId INT = NULL,
	@Hpii VARCHAR(16) = NULL
)
AS
BEGIN

	SELECT HealthProviderIndividualId,
           HealthProviderOrganisationNetworkId,
           Hpii,
           HpiiLastValidated,
           HpiiStatusId,
           DateCreated,
           UserCreated,
           DateModified,
           UserModified 
	FROM [hips].[HealthProviderIndividualHpii]
	WHERE HealthProviderOrganisationNetworkId = @HealthProviderOrganisationNetworkId
	AND (HealthProviderIndividualId = @HealthProviderIndividualId OR @HealthProviderIndividualId IS NULL)
	AND (Hpii = @Hpii OR @Hpii IS NULL)
	
END
GO
